﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_edit_view.aspx.cs" Inherits="VA.Modules.JDingCYTMobile.mainbiz.order_edit_view" %>
<%@ Import Namespace="System.Data"%>
<!DOCTYPE HTML>
<html>
<head>
<!--#include virtual="../include/viewport.aspx"-->
<title></title>      
<!--#include virtual="../include/css/edit.aspx"-->
<link href="../uicontrols/jtongui/themes/default/toolbarbutton.css" type="text/css" rel="Stylesheet" />
<link href="../uicontrols/jtongui/themes/icon.css" type="text/css" rel="Stylesheet" />
<!--#include virtual="../include/js/edit.aspx"--> 
<script type="text/javascript" src="../uicontrols/jtongui/plugins/jtong.toolbarbutton.js"></script>
<script type="text/javascript">    

    onPageInited = function () {
        JTongToolBarButton_init();
    }
    
    //加菜;
    function goAddFood() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_edit_addfood.aspx?orderno=" + orderNo + "&act=continue"
    }

    //减菜；
    function goRemoveFood() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_edit_removefood.aspx?orderno=" + orderNo
    }

    //调菜记录
    function orderChanges() {
        var orderNo = $("#hfKey").val();
        window.location.href = "order_changes.aspx?orderno=" + orderNo;
    }

    function save() {

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                bizNo = data.split("|")[1];
                showActResult("保存成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("保存失败：" + data, false, doAfterAdd, bizNo);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function checkOrder() {

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=check";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("确认成功！", true, doAfterCheck);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterCheck);
            }
            else {
                showActResult("确认失败：" + data, false, doAfterCheck);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function remindOrder() {

        var requestType = "POST";
        var url = pageName + "?act=remind";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        //var data = $("#form").eq(0).serialize(); //取不到值 ？？
        var data = { "hfKey": $("#hfKey").val() };
        var successFN = function (data, textStatus) {
            showActResult(data, true, null);
        };

        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function releaseOrder() {

        JTongAlertConfirm("确定菜已上齐吗？", function () {
            var requestType = "POST";
            var url = pageName + "?act=releaseorder";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();

            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("操作成功！", true, function () { window.location.reload(); });
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, doAfterAdd);
                }
                else {
                    showActResult("操作失败：" + data, false, doAfterAdd);
                }
            };

            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        });        
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            window.localStorage.clear();
            window.location.reload();
        }
    }
    function doAfterCheck(actResult) {
        if (actResult) {
            window.localStorage.clear();
            window.location.reload();
        }
    }

    function resetPage() {

        $("#txtTableNo").val("");
        $("#hfTableNo").val("");
        $("#txtCustomerQuantity").val("1");
        $("#txtRemark").val("");

        formEditListTable_clearRows();
        clearInputValidatorError();
    }

</script>

<script type="text/javascript">

    function addRowByOrder(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, bizStatus, originalRID) {
        formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, bizStatus, originalRID);
    }

    var formEditListTable_RowCounter = 0;
    function formEditListTable_addRow(itemType, itemCategory, itemCode, itemName, unit, price, quantity, zuofa, donateFlag, bizStatus, originalRID) {
            
        formEditListTable_RowCounter++;

        var $srcTable = $("#srcTable");
        var srcTableID = $srcTable.attr("id");

        //不要合并数量；
        ////如果找到相同数据行，并进行了数量的合并，则不再添加新的行；
        //if (formEditListTable_dataMerge($srcTable, itemCode, quantity)) {
        //    return;
        //}

        var rowHtml = '';
        var $row = null;
        var rowCnt = $srcTable[0].rows.length;
        var rowID = formEditListTable_RowCounter;

        itemName = itemName.replace(/'/g, "‘");
        unit = unit.replace(/'/g, "‘");
                        
        var amount = (price * quantity).toFixed(2).toString(); //优惠前金额
        
        rowHtml += '<tr id="tr_' + rowID + '">';
        
        rowHtml += '<td style="text-align:left;padding-left:5px;" onclick="viewDetail(\'' + itemCode + '\');">';
        rowHtml += '<span>' + itemName + '</span>';
        rowHtml += ' ';
        rowHtml += '<span>' + price + '</span>';
        rowHtml += '<input type="hidden" name="hfItemType" value="' + itemType + '" />';
        rowHtml += '<input type="hidden" name="hfItemCategory" value="' + itemCategory + '" />';
        rowHtml += '<input type="hidden" name="hfItemName" value="' + itemName + '" />';
        rowHtml += '<input type="hidden" name="hfItemCode" value="' + itemCode + '" id="hfItemCode_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfUnit" value="' + unit + '" />';
        rowHtml += '<input type="hidden" name="hfPrice" value="' + price + '" id="hfPrice_'+ rowID +'" />';
        rowHtml += '<input type="hidden" name="hfAmount" value="' + amount + '" id="hfAmount_' + rowID + '" />';
        rowHtml += '<input type="hidden" name="hfRID" value="' + amount + '" id="hfRID_' + rowID + '" />';
        rowHtml += '</td>';
    
        rowHtml += '<td><input type="text" name="txtQuantity" value="' + quantity + '" id="txtQuantity_' + rowID + '" class="textbox" onkeyup="formEditListTable_caculateAmount(' + rowID + ')" /></td>';


        rowHtml += '<td onclick="takeZuofa(' + rowID + ')">';
        rowHtml += '<span id="spanZuofa_' + rowID + '">' + zuofa + '</span>';
        rowHtml += '<input class="zuofa" type="hidden" name="txtZuofa" maxlength="25" value="' + zuofa + '" id="txtZuofa_' + rowID + '" onclick="takeZuofa(' + rowID + ')" onkeyup="formEditListTable_processZuofaText(' + rowID + ')" />';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;">';
        if (donateFlag == "1") {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" checked="checked" onclick="setDonate(' + rowID + ')" />';
        } else {
            rowHtml += '<input type="checkbox" name="ckbDonate" id="ckbDonate_' + rowID + '" onclick="setDonate(' + rowID + ')" />';
        }            
        rowHtml += '<input type="hidden" name="hfDonate" value="'+ donateFlag +'" id="hfDonate_' + rowID + '" />';
        rowHtml += '</td>';

        rowHtml += '<td style="text-align:center;">';
        if (bizStatus == "3") {
            rowHtml += '<input type="checkbox" name="ckbBizStatus" id="ckbBizStatus_' + rowID + '" checked="checked" onclick="setBizStatus(' + rowID + ')" />';
        } else {
            rowHtml += '<input type="checkbox" name="ckbBizStatus" id="ckbBizStatus_' + rowID + '" onclick="setBizStatus(' + rowID + ')" />';
        }
        rowHtml += '<input type="hidden" name="hfBizStatus" value="' + bizStatus + '" id="hfBizStatus_' + rowID + '" />';
        rowHtml += '</td>';

        //rowHtml += '<td style="text-align:left;"></td>';

        ////rowHtml += '<td style="text-align:left;">';        
        ////rowHtml += '<input type="button" value="+" onclick="takeFood(\'+\',' + rowID + ');" />';
        ////rowHtml += '<input type="button" value="-" onclick="takeFood(\'-\','+ rowID +');" />';
        ////rowHtml += '</td>';

        //rowHtml += '</tr>';

        $row = $(rowHtml);
        $srcTable.append($row);

        formEditListTable_setRowNo();
        formEditListTable_setTotalAmount();
        formEditListTable_hideTbNoRecord();
    }

    function formEditListTable_setTotalAmount() {
        var $srcTable = $("#srcTable");
        $srcTable.find("#trTotal").remove();

        var totalRowHtml = '';
        var totalAmount = 0.00;
        //var $hfAmountList = $srcTable.find("input[name=hfAmount]");
        var dataRows = $srcTable.find("tr[id]");

        dataRows.each(function () {
            var $hfAmount = $(this).find("input[name=hfAmount]").eq(0);
            var $hfCkbDonate = $(this).find("input[name=ckbDonate]").eq(0);

            if (!$hfCkbDonate[0].checked) {
                totalAmount += parseFloat($hfAmount.val());
            }
        });

        //$hfAmountList.each(function () {
        //    totalAmount += parseFloat($(this).val());
        //});

        //if ($hfAmountList.length > 0) {  //如果有数据行，则添加合计行
        if (dataRows.length > 0) {  //如果有数据行，则添加合计行     
            $("#hfTotalAmount").val(totalAmount.toFixed(2).toString());
            $("#spanTotalAmount").html(totalAmount.toFixed(2).toString());
        } else {
            $("#hfTotalAmount").val("0.00");
            $("#spanTotalAmount").html("0.00");
        }
    }

    function formEditListTable_caculateAmount(rowID) {
        var $txtQuantity = $("#txtQuantity_" + rowID);
        var $txtPrice = $("#hfPrice_" + rowID);
        var $spanDiscount = "";
        var sQuantity = $txtQuantity.val();
        var sPrice = $txtPrice.val();
        var amount = 0.00; //优惠前

        if (sQuantity == "") {
            sQuantity = "0";
        }
        if (sPrice == "") {
            sPrice = "0";
        }
 
        ////清除非数字字符；(会影响光标键输入，故不再使用，更改为判断如果为非数字，直接清空)
        //clearNoNum($txtQuantity[0]);
        //clearNoNum($txtPrice[0]);

        if (isNaN(sQuantity)) {
            alert("数量为无效数字！");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (isNaN(sPrice)) {
            alert("单价为无效数字.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }          
        if (parseFloat(sQuantity) > 100000 || parseFloat(sQuantity) <0) {  //限制数量不能超过100000
            alert("数量不能小于0或超过100000.");
            $txtQuantity.val("");
            $txtQuantity.focus();
            return;
        }
        if (parseFloat(sPrice) > 100000 || parseFloat(sPrice) < 0) {  //单价不能超过100000
            alert("单价不能小于0或超过100000.");
            $txtPrice.val("");
            $txtPrice.focus();
            return;
        }

        if ($txtQuantity.hasClass("error")) {
            $txtQuantity.removeClass("error");
        }
        if ($txtPrice.hasClass("error")) {
            $txtPrice.removeClass("error");
        }

        amount = parseFloat(sQuantity) * parseFloat(sPrice);
            
        $("#hfAmount_" + rowID).val(amount.toFixed(2).toString());
        $("#spanAmount_" + rowID).html(amount.toFixed(2).toString());

        formEditListTable_setTotalAmount();
    }

    function formEditListTable_checkTableData() {

        var result = true;

        var dataRowCount = 0;
        var $srcTable = $("#srcTable");

        $srcTable.find("input[name=txtQuantity]").each(function () {
            dataRowCount++;
            var sQuantity = $(this).val();
            if ($.trim(sQuantity) == "" || $.trim(sQuantity) == "0") {
                alert("数量不能为空或0！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });
        $srcTable.find("input[name=txtPrice]").each(function () {
            var sPrice = $(this).val();
            if ($.trim(sPrice) == "") {
                alert("单价不能为空！");
                $(this).focus();
                $(this).addClass("error");
                result = false;
                return;
            }
        });

        if (dataRowCount == 0) {
            alert("消费清单不能为空！");
            result = false;
        }

        return result;
    }        

    function clearItems() {
        formEditListTable_clearRows();
    }

    //做法============================================

    function formEditListTable_processZuofaText(rowID) {
        var $txtZuofa = $("#txtZuofa_" + rowID);
        var zuofa = $txtZuofa.val();
        zuofa = zuofa.replace(/,/g, "，");
        $txtZuofa.val(zuofa);
    }

    var $current_txtZuofa = null;
    var $current_spanZuofa = null;
    function takeZuofa(rowID) {
        var $txtZuofa = $("#txtZuofa_" + rowID);
        var $spanZuofa = $("#spanZuofa_" + rowID);
        $current_txtZuofa = $txtZuofa;
        $current_spanZuofa = $spanZuofa;
        openFrameWindow("口味列表", 200, 200, "get_foodmakeway_list.aspx?callback=takeZuofaCallback", true);
    }
    function takeZuofaCallback(trObj) {
        closeFrameWindow();
        var zuofa = $(trObj).find("td.zuofa").eq(0).html();
        $current_txtZuofa.val(zuofa);
        $current_spanZuofa.html(zuofa);

    }

    //赠送============================================

    function setDonate(rowID) {
        var $ckbDonate = $("#ckbDonate_" + rowID);
        var $hfDonate = $("#hfDonate_" + rowID);
        if ($ckbDonate[0].checked) {
            $hfDonate.val("1");
        } else {
            $hfDonate.val("0");
        }

        formEditListTable_setTotalAmount();
    }

    //上菜标记============================================

    function setBizStatus(rowID) {
        var $ckbBizStatus = $("#ckbBizStatus_" + rowID);
        var $hfBizStatus = $("#hfBizStatus_" + rowID);
        if ($ckbBizStatus[0].checked) {
            $hfBizStatus.val("3");
        } else {
            $hfBizStatus.val("1");
        }
    }

    //查看详情
    function viewDetail(itemCode) {
        window.location.href = "food_view.aspx?itemcode=" + itemCode;
        event.stopPropagation();  //阻止事件冒泡，避免行被选中；
    }

    </script>

<style type="text/css">
.textbox {
    width:30px;
    text-align:center;
}
.bottomBar {
    margin-top:-1px;
    padding:5px;
    text-align:center;
}
</style>

</head>
<body>

<form id="Form1" method="post" runat="server">

<div id="pageWrapper">    

    <div id="headerBar">
        <h1>菜单(<% = base.orderInfo.Table_No %> 号台，状态：<% = VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderBizStatusConverter.Convert_Value_ToText(base.orderInfo.Order_Biz_Status) %>)</h1>
        <div class="leftToolBar">
            <a href="javascript:window.history.back();" class="icon back"></a>            
        </div>                
        <div class="rightToolBar">
            <a href="javascript:goHome();" class="icon home"></a>
        </div>  
    </div> 

    <div id="toolBar">   
        <a href="javascript:goAddFood()" class="jtongui-toolbarbutton" icon="icon-add">加菜</a>
        <a href="javascript:goRemoveFood()" class="jtongui-toolbarbutton" icon="icon-remove">减菜</a>
        <a href="javascript:orderChanges()" class="jtongui-toolbarbutton" icon="icon-ok">调菜记录(<asp:Label ID="lblOrderChangeApplyCount" runat="server" ForeColor="Red" Font-Bold="true">0</asp:Label>)</a>
        <%--<a href="javascript:orderChanges()" class="jtongui-toolbarbutton" icon="icon-detail">变更</a>--%>       
    </div><!--toolBar.END-->  

    <div id="dataBar">

    <table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:0px;">
    <thead>
    <tr>
        <td style="text-align:center;">菜名</td>        	         	  	       	    
        <td style="width:40px;text-align:center;">数量</td>
        <td style="width:30px;text-align:center;">口味</td>
        <td style="width:25px;text-align:center;">赠</td>
        <td style="width:30px;text-align:center;">上菜</td>
    </tr>        
    </thead>
    </table>
   
    </div><!--dataBar.END-->

    <div class="bar bottomBar">
        <input type="hidden" name="hfTotalAmount" id="hfTotalAmount" />
        共 <span id="spanFoodKindQuantity"></span> 道菜，
        总金额：<span id="spanTotalAmount">0.00</span>
    </div>

    <% if (base.orderInfo.Order_Biz_Status != VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Finished.ToString("d") &&
           base.orderInfo.Order_Biz_Status != VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Canceled.ToString("d")) {%>
        
    <div id="bottomToolBar">
            <input type="button" id="btnSubmit" class="btn" style="width:80px" onclick="save()" value="保存" />                    
        
        <% if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.NewOrder.ToString("d")) {%>
            <input type="button" id="btnCheckOrder" class="btn" style="width:80px" onclick="checkOrder()" value="确认菜单" />
        <% } else if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Checked.ToString("d") || 
                      base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Processing.ToString("d") ) {%>
            <input type="button" id="btnRemindOrder" class="btn" style="width:60px" onclick="remindOrder()" value="催单" />             
        <% } %>
        

        <% if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Checked.ToString("d") || 
               base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Processing.ToString("d") ||
               base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Prepared.ToString("d")) {%>
            
            <input type="button" id="btnRelease" class="btn" style="width:80px" onclick="releaseOrder()" value="菜已上齐" />   

        <% } %>        

    </div>

    <% } %>    

    <!--#include virtual="../footer.aspx"-->

    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfTableNo" runat="server" />
    
</div>

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string RID = item.RID.ToString();
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string bizStatus = item.Biz_Status;

        Response.Write("{");
        Response.Write("\"RID\":\""+ RID +"\",\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\",\"bizStatus\":\"" + bizStatus + "\"");

        if (i == base.orderInfo.OrderItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    var originalFlag = "1";
    for (var i = 0; i < itemList.length; i++) {
        addRowByOrder(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].zuofa,
        itemList[i].donateFlag,
        itemList[i].bizStatus,
        itemList[i].RID);
    }
    $("#spanFoodKindQuantity").html(itemList.length);
</script>

<% } %>

</form>
</body>
</html> 